import java.util.Scanner;
import java.lang.reflect.Field;

public class Main
{
    public static void main(String[] args)
    {        
        Scanner s = new Scanner(System.in);
        //si recupera l'oggetto Class di Login, che permette di effettuare la riflessività
        Class<Login> c = Login.class;
        
        try{
            String username;
            
            //si recupera l'attributo username della classe Login
            Field field = c.getField("username");
            
            //si recupera l'annotazione dell'attributo username della classe Login
            CheckLengthAnnotation checkLengthAnnotation = field.getAnnotation(CheckLengthAnnotation.class);
            
            int min=-1;
            int max=-1;
            
            //si controlla che l'annotazione CheckRegExpAnnotation associata all'attributo username esista
            //e si recuperano i valori max e min
            if(checkLengthAnnotation!=null){
                min = checkLengthAnnotation.min();
                max = checkLengthAnnotation.max();
            }
            //si chiede di inserire lo username finchè il valore inserito non soddisfi i requisiti
            //definiti nell'annotazione
            do
            {
                System.out.println("inserisci lo username: ");
                username = s.nextLine();            
            }
            while((username.length()>max && max!=-1) || (username.length()<min && min!=-1));
            
            
            
            String password;
            //si recupera l'attributo password della classe Login
            field = c.getField("password");
            
            //si recupera l'annotazione dell'attributo username della classe Login
            checkLengthAnnotation = field.getAnnotation(CheckLengthAnnotation.class);
            
            min=-1;
            max=-1;
            
            //si controlla che l'annotazione CheckRegExpAnnotation associata all'attributo password esista
            //e si recuperano i valori max e min
            if(checkLengthAnnotation!=null){
                min = checkLengthAnnotation.min();
                max = checkLengthAnnotation.max();
            }         
            
            //si chiede di inserire la password finchè il valore inserito non soddisfi i requisiti
            //definiti nell'annotazione
            do
            {
                System.out.println("inserisci la password: ");
                password = s.nextLine();           
            }
            while((password.length()>max && max!=-1) || password.length()<min);
            
            
            System.out.println("login persistente?(1 per SI, 0 per NO) ");
            boolean isToMemLogin=false;
            if(s.hasNextInt()){
                int intIsToMemLogin = s.nextInt();
                if(intIsToMemLogin==1){
                    isToMemLogin=true;
                }
            }
            
            Login l = new Login(username, password, isToMemLogin);
            SrvUser srvU = new SrvUser();
            
            boolean isLogged = srvU.login(l);
            System.out.println("l'utente è loggato? " + isLogged);
        }
        catch(NoSuchFieldException e){
            System.out.println("Errore di configurazione");
        }
    }
}
